/* This code replicates Figure 5 and Figure 6 in the paper.  This do file plots Turkey macroeconomic data and combines the plots to output 2 panels of 2x2 .

Data is from: CRBT EVDS database, IAPOC index and Turkey's Ministry of Treasury and Finance.
*/

clear
cls

***Adjust path:
cap cd "Replication_pkg/Figure 5 and 6"

use "Data_fig5and6_turkey.dta", clear 

gen date = mofd(date(Date,"YM"))
format date %tmCCYY-NN
drop if date < tm(1999-01)
gen Year = year(date(Date,"YM"))

* Interest Rates
line CBRTRate date if(date>=tm(2002-02) & date<=tm(2023-05)), lc(blue) lwidth(thick) ///
	|| (line BankDepositRateupto3month date if(date>=tm(2002-02) & date<=tm(2023-05)), lc(red)  lwidth(thick)), ///
	xtitle("") xlab(, nogrid)   tlabel(2002-02(17)2023-05, angle(45)) ///
	ytitle("Percent") ylab(, nogrid) /// 
	ti("Interest Rates", size(medium)) legend(pos(6) label(1 "Policy Rate") label(2 "Deposit Rate") cols(2) size(vsmall)) plotregion(style(none)) ///
	tline(2008-01) tline(2018-07) tline(2011-03) tline(2008-01) tline(2021-07) ///
	ttext(60 2008-01 " End of IMF" " Program", place(e) size(vsmall)) ttext(60 2011-03 " European" " Crisis", place(e) size(vsmall)) ttext(60 2016-12 " Trump-Erdogan" " Crisis", place(e) size(vsmall)) ttext(60 2021-07 " Fisherian" " Experiment", place(e) size(vsmall)) ///
	xsize(5.5) ysize(4)
graph save Turkey_rates, replace

* External Debt
egen xDtag = tag(ExternalDebt)
line ExternalDebt Year if(xDtag), lc(black)  lwidth(thick) ///
	xtitle("") xlab(, nogrid)  tlabel(1999(4)2023) ///
	ytitle("% of GDP") ylab(, nogrid) ///
	ti("External Debt, % of GDP", size(medium)) legend(pos(6)  cols(1)) plotregion(style(none))  ///
	tline(2001) tline(2008) tline(2011) tline(2018) tline(2021) ///
	ttext(60 2008 " End of IMF" " Program", place(e) size(vsmall)) ttext(60 2011 " European" " Crisis", place(e) size(vsmall)) ttext(60 2016 " Trump-Erdogan" " Crisis", place(e) size(vsmall)) ttext(60 2001 " Financial" " Crisis", place(e) size(vsmall)) ttext(60 2021 " Fisherian" " Experiment", place(e) size(vsmall)) ///
	xsize(5.5) ysize(4)
graph save Turkey_xDebt, replace

* Domestic Debt
egen fDtag = tag(CentralGovernmentDebtStock)
line CentralGovernmentDebtStock date if(fDtag), lc(black)  lwidth(thick) ///
	xtitle("")  xlab(, nogrid)   tlabel(1999-01(48)2023-01, format(%tmCCYY))  ///
	ytitle("% of GDP") ylab(, nogrid) ///
	ti("Domestic Debt, % of GDP", size(medium)) legend(pos(6)  cols(1)) plotregion(style(none)) ///
	/*note("Note: Central Government Debt")*/ ///
	tline(2001-03) tline(2008-01) tline(2018-07) tline(2011-03) tline(2021-07) ///
	ttext(80 2008-01 " End of IMF" " Program", place(e) size(vsmall)) ttext(80 2011-03 " European" " Crisis", place(e) size(vsmall)) ttext(80 2016-12 " Trump-Erdogan" " Crisis", place(e) size(vsmall)) ttext(80 2001-03 " Financial" " Crisis", place(e) size(vsmall)) ttext(80 2021-07 " Fisherian" " Experiment", place(e) size(vsmall)) ///
	xsize(5.5) ysize(4)
graph save Turkey_domesticDebt, replace 

* Inflation
egen cpitag = tag(CPI)
line CPI date if(cpitag), lc(black)  lwidth(thick) ///
	xtitle("")  xlab(, nogrid)  tlabel(1999-01(42)2023-07,  labsize(small)) /// 
	ytitle("%") ylab(, nogrid) yla(0 20 40 60 80 ) /// 
	ti("Inflation", size(medium)) legend(pos(6)  cols(1) rows(2) holes(1/2)) plotregion(style(none)) ///
	tline(2001-03) tline(2008-01) tline(2018-07) tline(2011-03) tline(2021-07) ///
	yline(3.99, noextend) yline(5, lc(red) noextend) ///
	ttext(85 2008-01 " End of IMF" " Program", place(e) size(vsmall)) ttext(85 2011-03 " European" " Crisis", place(e) size(vsmall)) ttext(85 2016-12 " Trump-Erdogan" " Crisis", place(e) size(vsmall)) ttext(85 2001-03 " Financial" " Crisis", place(e) size(vsmall)) ttext(60 2021-07 "Fisherian " "Experiment ", place(w) size(vsmall)) ///
	ttext(3.99 2002-11 "Low Inflation 3.99%", place(s) size(vsmall)) ttext(7 2000-01 "Inflation ""Target 5%", place(n) size(vsmall) color(red))
graph save Turkey_CPI, replace

* Inflation Expectations
egen acpitag = tag(MonthAheadCPI)
line MonthAheadCPI date if(acpitag), lc(black) lwidth(medium) ///
	|| (line D date if(acpitag), lc(black) lp(dash) lwidth(medium)), ///
	xtitle("") xlab(, nogrid)  xlabel(#22,  labsize(small)) ///
	ytitle("Forward CPI") ylab(, nogrid) ///
	ti("Inflation Expectations", size(medium)) legend(pos(6) cols(2) size(tiny) justification(left)) plotregion(style(none)) ///
	tline(2008-01) tline(2018-07) tline(2011-03) tline(2021-07)  /// 
	tlabel(2001-08(44)2023-08) ttext(52 2008-01 " End of IMF" " Program", place(e) size(vsmall)) ttext(52 2011-03 " European" " Crisis", place(e) size(vsmall)) ttext(52 2016-12 " Trump-Erdogan" " Crisis", place(e) size(vsmall)) ttext(52 2021-07 " Fisherian" " Experiment", place(e) size(vsmall))
graph save Turkey_ForwardCPI, replace

* Fiscal Deficit
egen deftag = tag(PrimaryDeficittoGDP)
line PrimaryDeficittoGDP date if(deftag), lc(black)  lwidth(thick) ///
	|| (line BudgetDeficittoGDP date if(deftag), lc(black)  lwidth(thick) lp(dash)) , ///
	xtitle("") xlab(, nogrid) tlabel(2000-06(23)2023-06, angle(45)) ///
	ytitle("% of GDP") ylab(0 5 10 15 20, nogrid) ///
	ti("Fiscal Deficit, % of GDP", size(medium)) legend(pos(6)  label (1 "Primary Deficit") label (2 "Budget Balance") cols(2) size(vsmall)) plotregion(style(none)) ///
	tline(2008-01) tline(2018-07) tline(2011-03) tline(2021-07) ///
	ttext(20 2008-01 " End of IMF" " Program", place(e) size(vsmall)) ttext(20 2011-03 " European" " Crisis", place(e) size(vsmall)) ttext(20 2016-12 " Trump-Erdogan" " Crisis", place(e) size(vsmall)) ttext(20 2021-07 " Fisherian" " Experiment", place(e) size(vsmall)) ///
	xsize(5.5) ysize(4)
graph save Turkey_Alldeficit, replace

* 2x2 panel with Deficit, Domestic Deebt, External Debt, and Interest Rates
graph combine Turkey_Alldeficit.gph Turkey_rates.gph Turkey_domesticDebt.gph Turkey_xDebt.gph
graph export fig5.pdf, replace


* Load other data set
use "Data_fig5and6.dta", clear

sort date

* Exchange Rates
egen ertag = tag(ER_eop)
line ER_eop date if(date >= tm(2002-01)), lc(black)  lwidth(thick) ///
	xtitle("") xlab(, nogrid)  tlabel(2002-01(36)2023-01, /*angle(45)*/ labsize(small)) /// 
	ytitle("USD/TRY") ylab(, nogrid) /// 
	ti("Exchange Rate", size(medium)) legend(pos(6)  cols(1)) plotregion(style(none)) ///
	tline(2008-01) tline(2018-07) tline(2011-03) tline(2021-07) ///
	ttext(25 2008-01 " End of IMF" " Program", place(e) size(vsmall)) ttext(25 2011-03 " European" " Crisis", place(e) size(vsmall)) ttext(25 2016-12 " Trump-Erdogan" " Crisis", place(e) size(vsmall)) ttext(25 2021-07 " Fisherian" " Experiment", place(e) size(vsmall))
graph save Turkey_ER, replace


* Policy Credibility
gen classify = 1
replace classify = 2 if date >= tm(2021-01)
graph bar iapocchange, over(classify, label(labsize(small)) relabel(1 "2007-2018" 2 "2018-2021")) ///
	asyvars showyvars legend(off) plotregion(style(none)) ylab(, nogrid) ///
	bar(1, color(blue) fi(inten70)) bar(2, color(red) fi(inten70)) ytitle("% Change") title("Policy Credibility", size(medium)) bargap(3)
graph save Turkey_IAPOC, replace


* 2x2 panel with Inflation, Inflation expectations, Exchange Rates, and Credibility
grc1leg Turkey_CPI.gph Turkey_ForwardCPI.gph Turkey_ER.gph Turkey_IAPOC.gph,legendfrom(Turkey_ForwardCPI.gph) ring(0) pos(3)
graph export fig6.pdf, replace
